define("tiny_media/embed/embedhelpers",["exports","../selectors","core/str","../common","editor_tiny/options","core/ajax","../helpers"],(function(_exports,_selectors,_str,_common,_options,_ajax,_helpers){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Tiny media plugin embed helpers.
   *
   * This provides easy access to any classes without instantiating a new object.
   *
   * @module      tiny_media/embed/embedhelpers
   * @copyright   2024 Stevani Andolo <stevani@hotmail.com.au>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.prepareMoodleLang=_exports.mediaDetailsTemplateContext=_exports.insertMediaThumbnailTemplateContext=_exports.insertMediaTemplateContext=_exports.hasAudioVideoAttr=_exports.getSelectedMediaElement=_exports.getMoodleLangObj=_exports.getMediaTitle=_exports.getHelpStrings=_exports.getEmbeddedMediaDetails=_exports.fetchPreview=_exports.checkMediaType=void 0,_selectors=_interopRequireDefault(_selectors),_ajax=_interopRequireDefault(_ajax);_exports.insertMediaTemplateContext=props=>({mediaType:props.mediaType,showDropzone:props.canShowDropZone,showFilePicker:props.canShowFilePicker,fileType:"audio/video"});_exports.insertMediaThumbnailTemplateContext=props=>({elementid:props.editor.id,showDropzone:props.canShowDropZone,showImageFilePicker:props.canShowImageFilePicker,bodyTemplate:_selectors.default.EMBED.template.body.insertMediaBody,footerTemplate:_selectors.default.EMBED.template.footer.insertMediaFooter,fileType:"image",selector:_selectors.default.EMBED.type});_exports.getSelectedMediaElement=editor=>{let mediaType=null,selectedMedia=null;const mediaElm=editor.selection.getNode();return mediaElm?"video"===mediaElm.nodeName.toLowerCase()||"audio"===mediaElm.nodeName.toLowerCase()?(mediaType=mediaElm.nodeName.toLowerCase(),selectedMedia=mediaElm):mediaElm.querySelector("video")?(mediaType="video",selectedMedia=mediaElm.querySelector("video")):mediaElm.querySelector("audio")?(mediaType="audio",selectedMedia=mediaElm.querySelector("audio")):"a"===mediaElm.nodeName.toLowerCase()&&(selectedMedia=mediaElm):(mediaType=null,selectedMedia=null),[mediaType,selectedMedia]};_exports.fetchPreview=async(url,contextId)=>{const request={methodname:"tiny_media_preview",args:{contextid:contextId,content:url}};return(await _ajax.default.call([request])[0]).content};_exports.checkMediaType=async url=>{try{const contentType=(await fetch(url,{method:"HEAD"})).headers.get("Content-type");return contentType?contentType.startsWith("video/")?"video":contentType.startsWith("audio/")?"audio":null:null}catch(e){return null}};_exports.getMediaTitle=async(url,props)=>{const parsedUrl=new URL(url),pathName=parsedUrl.pathname,extension=pathName.includes(".")?pathName.split(".").pop():null;if(extension&&props.acceptedMediaTypes.includes(".".concat(extension)))return(0,_helpers.getFileName)(url);const hashTitle=parsedUrl.hash?parsedUrl.hash.substring(1):null;return hashTitle||null};_exports.mediaDetailsTemplateContext=async props=>({...{bodyTemplate:_selectors.default.EMBED.template.body.mediaDetailsBody,footerTemplate:_selectors.default.EMBED.template.footer.mediaDetailsFooter,isLink:"link"===props.mediaType,isVideo:"video"===props.mediaType,showControl:"video"===props.mediaType||"audio"===props.mediaType,isUpdating:props.isUpdating,isNewFileOrLinkUpload:props.newMediaLink||props.newFileUpload,selector:_selectors.default.EMBED.type},...props});_exports.getHelpStrings=async()=>{const[subtitles,captions,descriptions,chapters,metadata,customsize,linkcustomsize]=await(0,_str.getStrings)(["subtitles_help","captions_help","descriptions_help","chapters_help","metadata_help","customsize_help","linkcustomsize_help"].map((key=>({key:key,component:_common.component}))));return{subtitles:subtitles,captions:captions,descriptions:descriptions,chapters:chapters,metadata:metadata,customsize:customsize,linkcustomsize:linkcustomsize}};_exports.prepareMoodleLang=editor=>{const moodleLangs=(0,_options.getMoodleLang)(editor),currentLanguage=(0,_options.getCurrentLanguage)(editor);return{installed:Object.entries(moodleLangs.installed).map((_ref=>{let[code,lang]=_ref;return{lang:lang,code:code,default:code===currentLanguage}})),available:Object.entries(moodleLangs.available).map((_ref2=>{let[code,lang]=_ref2;return{lang:lang,code:code,default:code===currentLanguage}}))}};_exports.getMoodleLangObj=(subtitleLang,editor)=>{const{available:available}=(0,_options.getMoodleLang)(editor);return available[subtitleLang]?{lang:subtitleLang,code:available[subtitleLang]}:null};_exports.getEmbeddedMediaDetails=props=>{var _props$media$poster;const tracks={subtitles:[],captions:[],descriptions:[],chapters:[],metadata:[]};props.root.querySelectorAll(_selectors.default.EMBED.elements.mediaMetadataTabPane).forEach((metaData=>{metaData.querySelectorAll(_selectors.default.EMBED.elements.track).forEach((track=>{tracks[metaData.dataset.trackKind].push({src:track.querySelector(_selectors.default.EMBED.elements.url).value,srclang:track.querySelector(_selectors.default.EMBED.elements.trackLang).value,label:track.querySelector(_selectors.default.EMBED.elements.trackLabel).value,defaultTrack:track.querySelector(_selectors.default.EMBED.elements.trackDefault).checked})}))}));const querySelector=element=>props.root.querySelector(element),mediaDataProps={};return mediaDataProps.media={type:props.mediaType,sources:props.media,poster:null!==(_props$media$poster=props.media.poster)&&void 0!==_props$media$poster?_props$media$poster:null,title:querySelector(_selectors.default.EMBED.elements.title).value,width:querySelector(_selectors.default.EMBED.elements.width).value,height:querySelector(_selectors.default.EMBED.elements.height).value,autoplay:querySelector(_selectors.default.EMBED.elements.mediaAutoplay).checked,loop:querySelector(_selectors.default.EMBED.elements.mediaLoop).checked,muted:querySelector(_selectors.default.EMBED.elements.mediaMute).checked,controls:querySelector(_selectors.default.EMBED.elements.mediaControl).checked,tracks:tracks},mediaDataProps.link=!1,mediaDataProps};_exports.hasAudioVideoAttr=(elem,attr)=>elem.hasAttribute(attr)&&(elem.getAttribute(attr)||""===elem.getAttribute(attr))}));

//# sourceMappingURL=embedhelpers.min.js.map